---@meta

---@class AAudioGameplayVolume : AVolume
---@field AGVComponent UAudioGameplayVolumeComponent
---@field bEnabled boolean
---@field OnListenerEnterEvent FAudioGameplayVolumeOnListenerEnterEvent
---@field OnListenerExitEvent FAudioGameplayVolumeOnListenerExitEvent
local AAudioGameplayVolume = {}

---@param bEnable boolean
function AAudioGameplayVolume:SetEnabled(bEnable) end
function AAudioGameplayVolume:OnRep_bEnabled() end
function AAudioGameplayVolume:OnListenerExit() end
function AAudioGameplayVolume:OnListenerEnter() end


---@class UAGVConditionProxy : UAudioGameplayVolumeProxy
local UAGVConditionProxy = {}


---@class UAGVPrimitiveComponentProxy : UAudioGameplayVolumeProxy
local UAGVPrimitiveComponentProxy = {}


---@class UAttenuationVolumeComponent : UAudioGameplayVolumeMutator
---@field ExteriorVolume float
---@field ExteriorTime float
---@field InteriorVolume float
---@field InteriorTime float
local UAttenuationVolumeComponent = {}

---@param Volume float
---@param InterpolateTime float
function UAttenuationVolumeComponent:SetInteriorVolume(Volume, InterpolateTime) end
---@param Volume float
---@param InterpolateTime float
function UAttenuationVolumeComponent:SetExteriorVolume(Volume, InterpolateTime) end


---@class UAudioGameplayVolumeComponent : UAudioGameplayComponent
---@field OnProxyEnter FAudioGameplayVolumeComponentOnProxyEnter
---@field OnProxyExit FAudioGameplayVolumeComponentOnProxyExit
---@field Proxy UAudioGameplayVolumeProxy
local UAudioGameplayVolumeComponent = {}



---@class UAudioGameplayVolumeComponentBase : UAudioGameplayComponent
local UAudioGameplayVolumeComponentBase = {}


---@class UAudioGameplayVolumeMutator : UAudioGameplayComponent
---@field Priority int32
local UAudioGameplayVolumeMutator = {}

---@param InPriority int32
function UAudioGameplayVolumeMutator:SetPriority(InPriority) end


---@class UAudioGameplayVolumeProxy : UObject
local UAudioGameplayVolumeProxy = {}


---@class UAudioGameplayVolumeSubsystem : UAudioEngineSubsystem
---@field TransientProxyList TArray<UAudioGameplayVolumeProxy>
---@field AGVComponents TMap<uint32, UAudioGameplayVolumeComponent>
local UAudioGameplayVolumeSubsystem = {}



---@class UFilterVolumeComponent : UAudioGameplayVolumeMutator
---@field ExteriorLPF float
---@field ExteriorLPFTime float
---@field InteriorLPF float
---@field InteriorLPFTime float
local UFilterVolumeComponent = {}

---@param Volume float
---@param InterpolateTime float
function UFilterVolumeComponent:SetInteriorLPF(Volume, InterpolateTime) end
---@param Volume float
---@param InterpolateTime float
function UFilterVolumeComponent:SetExteriorLPF(Volume, InterpolateTime) end


---@class UReverbVolumeComponent : UAudioGameplayVolumeMutator
---@field ReverbSettings FReverbSettings
local UReverbVolumeComponent = {}

---@param NewReverbSettings FReverbSettings
function UReverbVolumeComponent:SetReverbSettings(NewReverbSettings) end


---@class USubmixOverrideVolumeComponent : UAudioGameplayVolumeMutator
---@field SubmixOverrideSettings TArray<FAudioVolumeSubmixOverrideSettings>
local USubmixOverrideVolumeComponent = {}

---@param NewSubmixOverrideSettings TArray<FAudioVolumeSubmixOverrideSettings>
function USubmixOverrideVolumeComponent:SetSubmixOverrideSettings(NewSubmixOverrideSettings) end


---@class USubmixSendVolumeComponent : UAudioGameplayVolumeMutator
---@field SubmixSendSettings TArray<FAudioVolumeSubmixSendSettings>
local USubmixSendVolumeComponent = {}

---@param NewSubmixSendSettings TArray<FAudioVolumeSubmixSendSettings>
function USubmixSendVolumeComponent:SetSubmixSendSettings(NewSubmixSendSettings) end


